% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/focalSpecies.R
\name{focalSpReport}
\alias{focalSpReport}
\title{Summarise all records for a species}
\usage{
focalSpReport(
  x,
  focalSp = NULL,
  long = TRUE,
  colVis = "grey",
  colPres = "red",
  ...
)
}
\arguments{
\item{x}{an object of class \sQuote{SummarizeBirds}.}

\item{focalSp}{the focal spp to look for.}

\item{long}{whether the map should be long or wide.}

\item{colVis}{color to plot visited gird cells}

\item{colPres}{color to plot grid cells where species is present}

\item{...}{further plot parameters}
}
\value{
a plot with a brief species summary
}
\description{
This function will produce a simple visual report for the obsrevation pattern
of the focal species. It shows grid cells with records on a map,
and bar charts with number of records per year and month.
}
\examples{
\donttest{
library(sp)
OB <- organizeBirds(bombusObsShort, sppCol = "scientificName", simplifySppName = TRUE)
grid <- makeGrid(searchPolygon, gridSize = 10)
SB <- summariseBirds(OB, grid=grid)
allSpp <- listSpecies(SB)
focal <- allSpp[2]
focalSpReport(SB, focalSp=focal)
}
}
\seealso{
\code{\link{summarizeBirds}}, \code{\link{exportBirds}}
}
