% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBioclimParam.R
\name{getBioclimParam}
\alias{getBioclimParam}
\title{Retrieving bioclimatic parameters}
\usage{
getBioclimParam(coord)
}
\arguments{
\item{coord}{Coordinates of the site(s), a matrix/dataframe with two columns (e.g. cbind(longitude, latitude)) (see examples).}
}
\value{
The function returns a data.frame with \code{tempSeas} (temperature seasonality,
i.e. bioclimatic variable 4 from the Worldclim dataset; Hijmans et al. 2005), \code{precSeas}
(precipitation seasonality, i.e. bioclimatic variable 15 from the Worldclim dataset; Hijmans
et al. 2005) and \code{CWD} (climatic water deficit; Chave et al. 2014).
}
\description{
This function extracts three bioclimatic parameters thanks to the coordinates of the data:
the Climatic Water Deficit (CWD), the Temperature Seasonality (TS) and the Precipitation Seasonality (PS).
}
\details{
The function is time-consuming at its first use as it downloads three raster files (one for each of
the parameter) which are then stored in forders named wc2-5 and CWD (see Localisation).

However, as soon as the raster is downloaded once, the function then runs fast.
}
\section{Localisation}{

The localisation of the folder is :
\itemize{
\item On Linux : \code{~/.local/share/R/BIOMASS}
\item On Mac OS X : \code{~/Library/Application Support/R/BIOMASS}
\item On Windows 7 up to 10 : \code{C:\\Users\\<username>\\AppData\\Local\\R\\BIOMASS\\R\\BIOMASS}
\item On Windows XP : \code{C:\\Documents and Settings\\<username>\\Data\\R\\BIOMASS\\R\\BIOMASS}
}

See this function for more information : \code{\link[rappdirs:user_data_dir]{rappdirs::user_data_dir()}}
}

\examples{
# One study site
lat <- 4.08
long <- -52.68
coord <- cbind(long, lat)
\dontrun{
bioclim <- getBioclimParam(coord)
}

# Several study sites (here three sites)
long <- c(-52.68, -51.12, -53.11)
lat <- c(4.08, 3.98, 4.12)
coord <- cbind(long, lat)
\dontrun{
bioclim <- getBioclimParam(coord)
}

}
\references{
Hijmans et al. (2005) \emph{Very high resolution interpolated climate surfaces for global land areas},
International journal of climatology, 25(15), 1965-1978.
Chave et al. (2014) \emph{Improved allometric models to estimate the above-ground biomass of tropical trees},
Global Change Biology, 20 (10), 3177-3190
}
\author{
Ariane TANGUY, Arthur PERE
}
\keyword{bioclim}
\keyword{internal}
\keyword{param}
