% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxR-functions.R
\name{plot.maxR}
\alias{plot.maxR}
\title{Plot of maxR object}
\usage{
\method{plot}{maxR}(
  x,
  main = "Contour plot for maxR",
  xlab = "Dose (Compound 1)",
  ylab = "Dose (Compound 2)",
  colorPalette = c("blue", "white", "red"),
  logScale = TRUE,
  zTransform = function(z) {
     z
 },
  plevels = c(0.7, 0.8, 0.9, 0.95, 0.99, 0.999),
  cutoff = max(plevels),
  maxshow = NULL,
  reverse.x = FALSE,
  reverse.y = FALSE,
  swapAxes = FALSE,
  ...
)
}
\arguments{
\item{x}{Output of \code{\link{maxR}}. This can also be \code{"maxR"}
element in the output of \code{\link{fitSurface}}.}

\item{main}{Fixed non-moving title for the 3D plot}

\item{xlab}{X axis label using font, size and color 
    \code{par(c("font.lab", "cex.lab", "col.lab"))}.}

\item{ylab}{Y axis label, same font attributes as \code{xlab}.}

\item{colorPalette}{Vector of color names for surface}

\item{logScale}{Draw doses on log-scale (setting zeroes to be finite constant)}

\item{zTransform}{Optional transformation function for z-axis. By default,
identity function is used.}

\item{plevels}{Probability levels used to generate a color scale}

\item{cutoff}{Probability cutoff to use for range of colors}

\item{maxshow}{Forced value for range of colors}

\item{reverse.x}{Reverse x axis?}

\item{reverse.y}{Reverse y axis?}

\item{swapAxes}{Swap x and y axes?}

\item{...}{Further arguments that are passed to \code{\link{format}} function
for formatting of axis labels}
}
\description{
Plot of maxR object
}
