% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxR-functions.R
\name{outsidePoints}
\alias{outsidePoints}
\title{List non-additive points}
\usage{
outsidePoints(maxR, B = 10000)
}
\arguments{
\item{maxR}{maxR statistics table returned by \code{Ymean} component from the
output of \code{\link{maxR}} function. This can also be \code{"maxR"}
element in the output of \code{\link{fitSurface}} function.}

\item{B}{Iterations to use for the distribution of the maxR statistic. This
is only used if \code{Ymean} dataframe does not have a \code{"distr"} attribute
attached as is normally done when using \code{\link{fitSurface}} or \code{\link{maxR}}
function.}
}
\value{
Returns a dataframe listing only dose combinations that exhibit
  significant deviations from the expected response surface.
}
\description{
List all points with corresponding p-values declared non-additive by the
maxR statistical test.
}
\examples{
  data <- subset(directAntivirals, experiment == 2)
  ## Data must contain d1, d2 and effect columns
  fitResult <- fitMarginals(data)
  CP <- CPBootstrap(data, fitResult, null_model = "loewe", B.CP = 5)
  statM <- maxR(data, fitResult, null_model = "loewe", CP = CP)
  outsidePoints(statM$Ymean)
}
