% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_ranges_box}
\alias{BIEN_ranges_box}
\title{Download range maps that intersect a specified bounding box.}
\usage{
BIEN_ranges_box(
  min.lat,
  max.lat,
  min.long,
  max.long,
  directory = NULL,
  species.names.only = FALSE,
  return.species.list = TRUE,
  crop.ranges = FALSE,
  include.gid = FALSE,
  ...
)
}
\arguments{
\item{min.lat}{Minimum latitude of the ranges included.}

\item{max.lat}{Maximum latitude of the ranges included.}

\item{min.long}{Minimum longitude of the ranges included.}

\item{max.long}{Maximum longitude of the ranges included.}

\item{directory}{Directory that range maps should be saved in.  If none is specified, range maps will be saved in the current working directory.}

\item{species.names.only}{Return species names rather than spatial data? Default is FALSE.}

\item{return.species.list}{Should a species list be returned in addition to downloading range maps?  Default is FALSE}

\item{crop.ranges}{Should the ranges be cropped to the focal area? Default is FALSE.}

\item{include.gid}{Should the files returned have a unique GID appended to them? This is needed if downloading multiple maps for the same species.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Range maps for all available species within the specified bounding box.
}
\description{
BIEN_ranges_box extracts range maps for a specified bounding box.
}
\note{
Details on the construction of BIEN range maps is available at https://bien.nceas.ucsb.edu/bien/biendata/bien-3/
}
\examples{
\dontrun{
temp_dir <- file.path(tempdir(), "BIEN_temp") #Set a working directory
BIEN_ranges_box(42,43,-85,-84,species.names.only = TRUE)
BIEN_ranges_box(42,43,-85,-84,directory = temp_dir)}
}
\seealso{
Other range functions: 
\code{\link{BIEN_ranges_genus}()},
\code{\link{BIEN_ranges_intersect_species}()},
\code{\link{BIEN_ranges_list}()},
\code{\link{BIEN_ranges_load_species}()},
\code{\link{BIEN_ranges_shapefile_to_skinny}()},
\code{\link{BIEN_ranges_skinny_ranges_to_richness_raster}()},
\code{\link{BIEN_ranges_spatialpolygons}()},
\code{\link{BIEN_ranges_species_bulk}()},
\code{\link{BIEN_ranges_species}()}
}
\concept{range functions}
