% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_trait_species}
\alias{BIEN_trait_species}
\title{Download trait data for given species.}
\usage{
BIEN_trait_species(species, print.query = FALSE, ...)
}
\arguments{
\item{species}{A single species or a vector of species.}

\item{print.query}{Should the PostgreSQL query be printed? The default value is FALSE.}

\item{...}{Additional arguments passed to BIEN_sql}
}
\value{
A dataframe of all available trait data for the given species.
}
\description{
BIEN_trait_species extracts trait data for the species specified.
}
\examples{
\dontrun{
BIEN_trait_species("Poa annua")
species_vector<-c("Poa annua","Juncus trifidus")
BIEN_trait_species(species_vector)}
}
\seealso{
Other trait functions: \code{\link{BIEN_trait_family}},
  \code{\link{BIEN_trait_list}},
  \code{\link{BIEN_trait_mean}},
  \code{\link{BIEN_trait_traitbyfamily}},
  \code{\link{BIEN_trait_traitbygenus}},
  \code{\link{BIEN_trait_traitbyspecies}},
  \code{\link{BIEN_trait_traits_per_species}},
  \code{\link{BIEN_trait_trait}}
}

