% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIEN.R
\name{BIEN_ranges_box}
\alias{BIEN_ranges_box}
\title{Download range maps that intersect a specified bounding box.}
\usage{
BIEN_ranges_box(min.lat, max.lat, min.long, max.long, directory = NULL,
  species_names_only = FALSE, return.species.list = TRUE,
  crop.ranges = FALSE, include.gid = FALSE, print.query = FALSE, ...)
}
\arguments{
\item{min.lat}{Minimum latitude of the ranges included.}

\item{max.lat}{Maximumlatitude of the ranges included.}

\item{min.long}{Minimum longitude of the ranges included.}

\item{max.long}{Maximum longitude of the ranges included.}

\item{directory}{Directory that range maps should be saved in.  If none is specified, range maps will be saved in the current working directory.}

\item{species_names_only}{Get a list of the species in the bounding box without downloading range maps. Default is FALSE.}

\item{return.species.list}{Should a species list be returned?  Only meaningful when maps are being downloaded.}

\item{crop.ranges}{Should the range maps be cropped to the GIS bounding box?  Default is FALSE.}

\item{include.gid}{Should the filenames returned have a unique GID appended to them? This is needed if downloading multiple maps for the same species. Default is FALSE.}

\item{print.query}{Should the PostgreSQL query be printed? The default value is FALSE.}

\item{...}{Additional arguments passed to BIEN_sql}
}
\value{
Range maps for all available species within the specified bounding box.
}
\description{
BIEN_ranges_box extracts range maps for a specified bounding box.
}
\examples{
\dontrun{
testwd<-"C:/wherever/you/want/files/saved/" #Set a working directory
BIEN_ranges_box(42,43,-85,-84,species_names_only = TRUE)
BIEN_ranges_box(42,43,-85,-84,directory = testwd)}
}
\seealso{
Other range functions: \code{\link{BIEN_ranges_genus}},
  \code{\link{BIEN_ranges_intersect_species}},
  \code{\link{BIEN_ranges_load_species}},
  \code{\link{BIEN_ranges_shapefile}},
  \code{\link{BIEN_ranges_species}}
}

