\name{PlotTheta}

\alias{PlotTheta}

\title{Plots and summarises the covariate coefficients}

\description{Plots density and histogram for one or all covariate coefficients and
computes summaries.}

\usage{PlotTheta(M, i = 1, plot.all = TRUE, quantiles = TRUE)}

\arguments{
  \item{M}{List. Output object generated by command \code{CGaMRes}.}
  \item{i}{Integer. If \code{plot.all == FALSE}, only the \emph{ith} position is plot.}
  \item{plot.all}{Logical. If \code{TRUE} plots all \code{p} covariate coefficients.}
  \item{quantiles}{Logical. If \code{TRUE} returns a matrix containing mean, standar deviation and quantiles for theta.}
}

\value{
  \item{quant}{Data frame. Mean, standard deviation, 0.025, 0.05, 0.5, 0.95 and 0.975 quantiles for theta.}
}

\references{
- Nieto-Barajas, L. E. (2003). Discrete time Markov gamma processes and time dependent covariates in survival analysis. \emph{Bulletin of the International Statistical Institute 54th Session}. Berlin. (CD-ROM).

- Nieto-Barajas, L. E. & Walker, S. G. (2002). Markov beta and gamma processes for modelling hazard rates. \emph{Scandinavian Journal of Statistics} \strong{29}: 413-424.
}

\seealso{\link{CGaMRes}}

\examples{
## Simulations may be time intensive. Be patient.

## Example 1
#  data(leukemiaFZ)
#  leukemia1 <- leukemiaFZ
#  leukemia1$wbc <- log(leukemiaFZ$wbc)
#  CGEX1 <- CGaMRes(data = leukemia1, K = 10, iterations = 10000, thpar = 10)
#  PlotTheta(CGEX1)
}
