% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm_compare_bf.default.R
\name{plot.summary.ggm_compare_explore}
\alias{plot.summary.ggm_compare_explore}
\title{Plot \code{summary.ggm_compare_explore} Objects}
\usage{
\method{plot}{summary.ggm_compare_explore}(x, size = 2, color = "black", ...)
}
\arguments{
\item{x}{An object of class \code{summary.ggm_compare_explore}}

\item{size}{Numeric. The size of the points (defaults to 2).}

\item{color}{Character string. The color of the points
(defaults to \code{"black"}).}

\item{...}{Currently ignored.}
}
\value{
A \code{ggplot} object
}
\description{
Visualize the posterior hypothesis probabilities.
}
\examples{
\donttest{
# note: iter = 250 for demonstrative purposes

# data
Y <- bfi

# males and females
Ymale <- subset(Y, gender == 1,
                   select = -c(gender,
                               education))[,1:10]

Yfemale <- subset(Y, gender == 2,
                     select = -c(gender,
                                 education))[,1:10]

##########################
### example 1: ordinal ###
##########################

# fit model
fit <- ggm_compare_explore(Ymale,  Yfemale,
                           type = "ordinal",
                           iter = 250,
                           progress = FALSE)
# summary
summ <- summary(fit)

plot(summ)
}
}
\seealso{
\code{\link{ggm_compare_explore}}
}
