% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm_compare_confirm.R
\name{plot.confirm}
\alias{plot.confirm}
\title{Plot \code{confirm} objects}
\usage{
\method{plot}{confirm}(x, ...)
}
\arguments{
\item{x}{An object of class \code{confirm}}

\item{...}{Currently ignored.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot the posterior hypothesis probabilities as a pie chart, with
each slice corresponding the probability of a given hypothesis.
}
\examples{

\donttest{

#####################################
##### example 1: many relations #####
#####################################

# data
Y <- bfi

hypothesis <- c("g1_A1--A2 > g2_A1--A2 & g1_A1--A3 = g2_A1--A3;
                 g1_A1--A2 = g2_A1--A2 & g1_A1--A3 = g2_A1--A3;
                 g1_A1--A2 = g2_A1--A2 = g1_A1--A3 = g2_A1--A3")

Ymale   <- subset(Y, gender == 1,
                  select = -c(education,
                              gender))[,1:5]


# females
Yfemale <- subset(Y, gender == 2,
                     select = -c(education,
                                 gender))[,1:5]

test <- ggm_compare_confirm(Ymale,
                            Yfemale,
                            hypothesis = hypothesis,
                            iter = 250,
                            progress = FALSE)


# plot
plot(test)
}
}
