% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm_compare_estimate.default.R
\name{summary.ggm_compare_estimate}
\alias{summary.ggm_compare_estimate}
\title{Summary method for \code{ggm_compare_estimate.default} objects}
\usage{
\method{summary}{ggm_compare_estimate}(object, cred = 0.95, ...)
}
\arguments{
\item{object}{An object of class \code{ggm_compare_estimate}}

\item{cred}{credible interval width}

\item{...}{currently ignored}
}
\value{
A list containing the summarized posterior distributions
}
\description{
Summary method for \code{ggm_compare_estimate.default} objects
}
\examples{
# data
Y1 <- BGGM::bfi[1:500,1:5]
Y2 <- BGGM::bfi[501:1000, 1:5]

# fit model
fit <- ggm_compare_estimate(Y1, Y2)

# posterior summary of differences
summary(fit)

}
\seealso{
\code{\link{ggm_compare_estimate.default}}
}
