% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence.R
\name{convergence}
\alias{convergence}
\title{MCMC Convergence Plots}
\usage{
convergence(x, type = "acf", param = "1--2")
}
\arguments{
\item{x}{object of class \code{estimate} or \code{explore}}

\item{type}{\code{acf} or \code{trace} plot}

\item{param}{edge name(s) (e.g., "1--2" or c("1--2", "1--3"))}
}
\value{
\code{ggplots}
}
\description{
Monitor converge of the MCMC sampler
}
\examples{
# plot
Y <- bfi[,1:5]

# fit model
fit <- estimate(Y)

# convergence plots
convergence(fit, type = "trace")
}
