% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfs_get_data.R
\name{bfs_get_data}
\alias{bfs_get_data}
\title{Download BFS data in a given language}
\usage{
bfs_get_data(
  number_bfs = NULL,
  language = "de",
  url_bfs = NULL,
  query = NULL,
  column_name_type = "text",
  variable_value_type = "text",
  clean_names = FALSE
)
}
\arguments{
\item{number_bfs}{The BFS number of a dataset.}

\item{language}{Language of the dataset to be translated if exists, i.e. "de", "fr", "it" or "en".}

\item{url_bfs}{The URL page of a dataset.}

\item{query}{A list with named values, a json query file or json query string using \code{pxweb::pxweb_query()}.}

\item{column_name_type}{Column name type as "text" or as "code".}

\item{variable_value_type}{Variable value type as "text" or as "code".}

\item{clean_names}{Clean column names using \code{janitor::clean_names()}.}
}
\value{
A tbl_df (a type of data frame; see tibble or
dplyr packages).
}
\description{
Download a dataset using the BFS offical API v1. You should choose either the bfs number of the bfs offical url
of a given dataset. You can query particulary variables using the `query` argument.
}
\seealso{
\code{\link{bfs_get_data_comments}}
}
