% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{bfs_search}
\alias{bfs_search}
\title{Search titles of available BFS datasets}
\usage{
bfs_search(
  data = bfs_get_metadata(),
  pattern,
  ignore.case = TRUE,
  fixed = FALSE
)
}
\arguments{
\item{data}{The data frame to search. This can be either a data frame
previously fetched using \code{\link{bfs_get_metadata}} (recommended) or left
blank, in which case a temporary data frame is fetched. The second option
adds a few seconds to each search query.}

\item{pattern}{A regular expression string to search for.}

\item{ignore.case}{Whether the search should be case-insensitive.}

\item{fixed}{logical. If TRUE, pattern is a string to be matched as is.}
}
\value{
A data frame.
}
\description{
Returns a tibble containing the titles, publication date,
observation periods, data source, metadata url and download urls of
available BFS datasets in a given language which match
the given criteria. This function leverages the R base function \code{grepl} 
but calls the data argument first to allow the use of the pipe operator from 
magrittr.
}
\examples{
\donttest{meta_en <- bfs_get_metadata(language = "en")}
\donttest{bfs_search(data = meta_en, pattern = "university students")}

}
\seealso{
\code{\link{bfs_get_metadata}}
}
