% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BETS.get.R
\name{BETS.get}
\alias{BETS.get}
\title{Get a complete time series from a BETS database}
\usage{
BETS.get(code, from = "", to = "", data.frame = FALSE, frequency = NULL)
}
\arguments{
\item{code}{A \code{character}. The unique code that references the time series. This code can be obtained by using the \code{\link{BETS.search}} function.}

\item{from}{A \code{character} or a \code{Data} object. Starting date of the time series (format YYYY-DD-MM).}

\item{to}{A \code{character} or a \code{Data} object. Ending date of the time series (format YYYY-DD-MM).}

\item{data.frame}{A \code{boolean}. True if you want the output to be a data frame. True to \code{ts} output.}

\item{frequency}{An \code{integer}. The frequency of the time series. It is not needed. It is going to be used only if the metadata for the series is corrupted.}
}
\value{
A \code{\link[stats]{ts}} (time series) object containing the desired series.
}
\description{
Extracts a complete time series from either the Central Bank of Brazil (BCB), the Brazilian Institute of Geography and Statistics (IBGE) or the Brazilian Institute of Economics (FGV/IBRE).
}
\note{
Due to the significant size of the databases, it could take a while to retrieve the values. However, it shouldn't take more than 90 seconds.
}
\examples{

 # Anual series: GDP at constant prices, in R$ (brazilian reais)
 #BETS.get(1208)
 
 # International reserves - Cash concept 
 #int.reserves <- BETS.get("3543")
 #plot(int.reserves)
 
 # Exchange rate - Free - United States dollar (purchase)
 #us.brl <- BETS.get(3691)
 
}
\seealso{
\code{\link[stats]{ts}}, \code{\link[BETS]{BETS.search}} and \code{\link[seasonal]{seas}}
}
\keyword{get}
