% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEnsemblGeneIds.R
\name{getEnsemblGeneIds}
\alias{getEnsemblGeneIds}
\title{Feeding BED: Download Ensembl DB and load gene information in BED}
\usage{
getEnsemblGeneIds(organism, release, gv, ddir, dbCref, dbAss, canChromosomes)
}
\arguments{
\item{organism}{character vector of 1 element corresponding to the organism
of interest (e.g. "Homo sapiens")}

\item{release}{the Ensembl release of interest (e.g. "83")}

\item{gv}{the genome version (e.g. "38")}

\item{ddir}{path to the directory where the data should be saved}

\item{dbCref}{a named vector of characters providing cross-reference DB of
interest. These DB are also used to find indirect ID associations.}

\item{dbAss}{a named vector of characters providing associated DB of
interest. Unlike the DB in dbCref parameter, these DB are not used for
indirect ID associations: the IDs are only linked to Ensembl IDs.}

\item{canChromosomes}{canonical chromosmomes to be considered as preferred
ID (e.g. c(1:22, "X", "Y", "MT") for human)}
}
\description{
Not exported to avoid unintended modifications of the DB.
}
