% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBeIds.R
\name{getBeIds}
\alias{getBeIds}
\title{Get biological entities identifiers}
\usage{
getBeIds(
  be = c(listBe(), "Probe"),
  source,
  organism = NA,
  restricted,
  entity = TRUE,
  attributes = NULL,
  verbose = FALSE,
  recache = FALSE,
  filter = NULL,
  caseSensitive = FALSE,
  limForCache = 100,
  bef = NULL
)
}
\arguments{
\item{be}{one BE or "Probe"}

\item{source}{the BE ID database or "Symbol" if BE or
the probe platform if Probe}

\item{organism}{organism name}

\item{restricted}{boolean indicating if the results should be restricted to
current version of to BEID db. If FALSE former BEID are also returned.}

\item{entity}{boolean indicating if the technical ID of BE should be
returned}

\item{attributes}{a character vector listing attributes that should be
returned.}

\item{verbose}{boolean indicating if the CQL query should be displayed}

\item{recache}{boolean indicating if the CQL query should be run even if
the table is already in cache}

\item{filter}{character vector on which to filter id. If NULL (default),
the result is not filtered: all IDs are taken into account.}

\item{caseSensitive}{if TRUE the case of provided symbols
is taken into account.
This option will only affect "Symbol" source
(default: caseSensitive=FALSE).}

\item{limForCache}{if there are more filter than limForCache results are
collected for all IDs (beyond provided ids) and cached for futur queries.
If not, results are collected only for provided ids and not cached.}

\item{bef}{For internal use only}
}
\value{
a data.frame mapping BE IDs with the
following fields:
\itemize{
\item \strong{id}: the BE ID
\item \strong{BE}: IF entity is TRUE the technical ID of BE
\item \strong{db.version}: IF be is not "Probe" and source not "Symbol"
the version of the DB
\item \strong{db.deprecated}: IF be is not "Probe" and source not "Symbol"
a value if the BE ID is deprecated or FALSE if it's not
\item \strong{canonical}: IF source is "Symbol" TRUE if the symbol is canonical
\item \strong{organism}: IF be is "Probe" the organism of the targeted BE
}

If attributes are part of the query, additional columns for each of them.
Scope ("be", "source" and "organism") is provided as a named list
in the "scope" attributes: \code{attr(x, "scope")}
}
\description{
Get biological entities identifiers
}
\examples{
\dontrun{
beids <- getBeIds(be="Gene", source="EntrezGene", organism="human", restricted=TRUE)
}

}
\seealso{
\link{listPlatforms}, \link{listBeIdSources}
}
