% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa_plot.R
\name{aa_plot}
\alias{aa_plot}
\title{Plot of Average mutation frequency of nucleotide mutations resulting in amino acid substitution}
\usage{
aa_plot(data, text, legend.position, characteristics)
}
\arguments{
\item{data}{Results from the function aa_dist or aa_cdr3_dist.}

\item{text}{The legend of the plot.}

\item{legend.position}{The position of the legend. It can be "none","left", "right", "bottom", "top".}

\item{characteristics}{is a data set data(Klassen) in this package}
}
\value{
Output is the plot of average mutation frequency of nucleotide mutations resulting in amino acid substitution. The classes are divided according to IMGT.
}
\description{
Plot of Average mutation frequency of nucleotide mutations resulting in amino acid substitution
}
\examples{
## data(IMGTtab7)
Regions<-cbind(IMGTtab7$FR1_IMGT,IMGTtab7$CDR1_IMGT)
\dontrun{allRegions_matrix<-aa_dist(Regions)}
## data(Klassen)
\dontrun{aa_plot(allRegions_matrix, "Amino acid Distribution", "right", Klassen)}
}
\references{
Pommie C., Levadoux S., Sabatier R., Lefranc G., and Lefranc MP. IMGT standardizedcriteria for statistical analysis of immunoglobulin V-REGION amino acid properties.J MolRecognit, 17(1):17-32, 2004.
}

