% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgeomBCD.R
\name{rgeomBCD}
\alias{rgeomBCD}
\title{Random Sampling from a Bivariate Geometric Distribution via Conditional Specification}
\usage{
rgeomBCD(n, q1, q2, q3, seed = 123)
}
\arguments{
\item{n}{number of samples to generate}

\item{q1}{probability parameter for \eqn{ X }, in \eqn{(0, 1]}}

\item{q2}{probability parameter for \eqn{ Y }, in\eqn{(0, 1]}}

\item{q3}{dependence parameter, in \eqn{(0, 1]}}

\item{seed}{seed for random number generation (default = 123)}
}
\value{
A data frame with two columns: `X` and `Y`, containing the sampled values.
}
\description{
Generates random samples from a bivariate geometric distribution (BGCD)
}
\examples{
# Generate 100 samples
samples <- rgeomBCD(n = 100, q1 = 0.5, q2 = 0.5, q3 = 0.00001)
head(samples)
cor(samples$X, samples$Y)  # Should be negative

}
