% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{plot.bayeslincom}
\alias{plot.bayeslincom}
\title{Plot comparisons from \code{compare}}
\usage{
\method{plot}{bayeslincom}(
  x,
  point_col = "black",
  hist_col = "black",
  hist_fill = "gray",
  bar_col = "steelblue",
  bins = 30,
  display_comb_strings = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{bayeslincom}}

\item{point_col}{Color for point indicating mean of posterior}

\item{hist_col}{Color for histogram edges}

\item{hist_fill}{Color for histogram bars}

\item{bar_col}{Color of bar for credible interval}

\item{bins}{Number of bins}

\item{display_comb_strings}{If \code{TRUE}, displays full strings for
combinations in \code{ggplot} facets  when there
is more than one combination in \code{x}}

\item{...}{Currently ignored}
}
\value{
An object of class \code{ggplot}
}
\description{
See \link[bayeslincom]{plot.bayeslincom}
}
\examples{
Y <- mtcars[, 1:3]
bb <- bbcor(Y)
bb_compare <- compare("mpg--cyl > mpg--disp",
                     obj = bb,
                     cred = 0.90,
                     rope = c(-0.1, 0.1))
plot(bb_compare)

}
