% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantify.binary.R
\name{quant}
\alias{quant}
\alias{quant.binary.integer}
\alias{quant.binary}
\alias{quant.binary.markov}
\alias{quant.binary.counts}
\alias{quant.binary.counts.integer}
\title{Quantification of binary capture histories}
\usage{
quant.binary.integer(x)

quant.binary(x)

quant.binary.markov(x, markov.ord)

quant.binary.counts(x)

quant.binary.counts.integer(x)
}
\arguments{
\item{x}{either a character string or a numeric vector exclusively made by binary entries 0 or 1.}

\item{markov.ord}{a positive integer representing the order of the Markovian structure which one is willing to reproduce with suitable partition of the unit interval and the quantification of capture history standardized in the unit interval}
}
\value{
For \code{quant.binary} it returns a numeric value within the unit interval [0,1] and \cr \code{quant.binary.markov}. For \code{quant.binary.integer} it returns an integer value.
}
\description{
The \code{quant.binary} family of functions allow to quantify binary capture histories (partial or complete) in terms of a meaningful quantity which can be interpreted as a possibly meaningful behavioral covariate (like memory persistence of previous capture history)
}
\details{
For a more detailed description of instances of meaningful behavioral covariates see Alunni Fegatelli and Tardella (2012) and Alunni Fegatelli (2013)[PhD Thesis]
}
\examples{

## Example of quantification with character input

capt.hist="0110"

quant.binary(capt.hist)
quant.binary.markov(capt.hist,markov.ord=2)
quant.binary.integer(capt.hist)
quant.binary.counts(capt.hist)
quant.binary.counts.integer(capt.hist)

## Example of quantification with numeric input

ch=c(0,1,1,0)
quant.binary(ch)
quant.binary.markov(ch,markov.ord=2)
quant.binary.integer(ch)
quant.binary.counts(ch)
quant.binary.counts.integer(ch)

}
\keyword{Partial_capture_history_quantification}
