% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_lineup.R
\name{do_lineup}
\alias{do_lineup}
\title{Compute ACB lineups}
\usage{
do_lineup(data, day_num, game_code, team_sel, verbose)
}
\arguments{
\item{data}{Play-by-play prepared data from a given game.}

\item{day_num}{Day number.}

\item{game_code}{Game code.}

\item{team_sel}{One of the teams' names involved in the game.}

\item{verbose}{Logical. Decide if information of the computations
must be provided or not.}
}
\value{
Data frame. Each row is a different lineup. This is the meaning of the 
columns that might not be explanatory by themselves:
\itemize{
  \strong{team_in}: Time point when that lineup starts playing together.
  \strong{team_out}: Time point when that lineup stops playing together 
  (because there is a substitution).
  \strong{num_players}: Number of players forming the lineup (must be 5 in this case).
  \strong{time_seconds}: Total of seconds that the lineup played.
  \strong{diff_points}: Game score in the time that the lineup played.
  \strong{plus_minus}: Plus/minus achieved by the lineup. This is the difference
  between the game score of the previous lineup and of the current one.
  \strong{plus_minus_poss}: Plus/minus per possession.
}
}
\description{
Compute all the lineups that a given team shows during a game.
}
\note{
A possession lasts 24 seconds in the ACB league.
}
\examples{
library(dplyr)
df0 <- acb_vbc_cz_pbp_2223

day_num <- unique(acb_vbc_cz_pbp_2223$day)
game_code <- unique(acb_vbc_cz_pbp_2223$game_code)

acb_games_2223_sl <- acb_vbc_cz_sl_2223 \%>\%
  filter(period == "1C")

df1 <- do_prepare_data(df0, day_num, 
                       acb_games_2223_sl, acb_games_2223_info,
                       game_code)
                
df2 <- do_lineup(df1, day_num, game_code, "Valencia Basket", FALSE)    
#df2

}
\author{
Guillermo Vinue
}
