% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{dispersion}
\alias{dispersion}
\title{Phylogenetic/functional dispersion of species or individuals.}
\usage{
dispersion(
  comm,
  tree,
  distance,
  func = "originality",
  abund = TRUE,
  relative = TRUE
)
}
\arguments{
\item{comm}{A sites x species matrix, with either abundance or incidence data. If missing, the dispersion using the full tree or distance matrix is calculated.}

\item{tree}{A phylo or hclust object (used only for PD or FD) or alternatively a species x traits matrix or data.frame to build a functional tree.}

\item{distance}{A dist object representing the phylogenetic or functional distance between species.}

\item{func}{Calculate dispersion using originality (default), uniqueness or contribution.}

\item{abund}{A boolean (T/F) indicating whether dispersion should be calculated using individuals (T) or species (F).}

\item{relative}{A boolean (T/F) indicating whether dispersion should be relative to the maximum distance between any two species in the tree or distance matrix.}
}
\value{
A vector of values per site (or a single value if no comm is given).
}
\description{
Average dissimilarity between any two species or individuals randomly chosen in a community.
}
\details{
If abundance data is used and a tree is given, dispersion is the quadratic entropy of Rao (1982).
If abundance data is not used but a tree is given, dispersion is the phylogenetic dispersion measure of Webb et al. (2002).
}
\examples{
comm <- matrix(c(1,2,0,0,0,1,1,0,0,0,0,2,2,0,0,0,0,1,1,1), nrow = 4, byrow = TRUE)
distance <- dist(c(1:5), method="euclidean")
tree <- hclust(distance, method="average")
dispersion(tree = tree)
dispersion(distance = distance)
dispersion(comm, tree)
dispersion(comm, tree, abund = FALSE)
dispersion(comm, tree, abund = FALSE, relative = FALSE)
}
\references{
Rao, C.R. (1982) Diversity and dissimilarity coefficients: a unified approach. Theoretical Population Biology, 21: 24-43.

Webb, C.O., Ackerly, D.D., McPeek, M.A. & Donoghue, M.J. (2002) Phylogenies and community ecology. Annual Review of Ecology and Systematics, 33: 475-505.
}
