% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{ses}
\alias{ses}
\title{Standard Effect Size.}
\usage{
ses(obs, est, param = TRUE, p = TRUE)
}
\arguments{
\item{obs}{A single observed value.}

\item{est}{A vector with estimated values.}

\item{param}{Value is calculated with parametric or non-parametric method. The later is preferable when distribution of estimated values is not normally distributed.}

\item{p}{Boolean indicating whether the p-value should be calculated based on the rank of 'obs' in 'est'. As the test is two-sided, usual significance is indicated by p < 0.025 or p > 0.975.}
}
\value{
The ses value or a vector with ses and p-value.
}
\description{
Calculates the standard effect size from observed and estimated values.
}
\examples{
est = rnorm(1000, 500, 100)

ses(100, est)
ses(100, est, param = FALSE)
ses(500, est)
ses(500, est, param = FALSE)
ses(900, est, p = TRUE)
ses(900, est, param = FALSE, p = TRUE)
}
