% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{alpha.accum}
\alias{alpha.accum}
\title{Alpha diversity accumulation curves (observed and estimated).}
\usage{
alpha.accum(
  comm,
  tree,
  func = "nonparametric",
  target = -2,
  runs = 100,
  prog = TRUE
)
}
\arguments{
\item{comm}{A sampling units x species matrix, with either abundance or incidence data.}

\item{tree}{An hclust or phylo object (used only for Phylogenetic (PD) or Functional (FD) Diversity, not for Taxon Diversity (TD)).}

\item{func}{The class of estimators to be used:
If func is partial match of "curve", TD, PD or FD are based on extrapolating the accumulation curve of observed diversity.
If func is partial match of "nonparametric", TD, PD or FD are based on non-parametric estimators.
If func is partial match of "completeness", PD or FD estimates are based on the completeness of TD (requires a tree to be used).
If not specified, default is "nonparametric.}

\item{target}{True diversity value to calculate the accuracy of curves (scaled mean squared error). If not specified do not calculate accuracy (default), -1 uses the total observed diversity as true diversity and any other value is the true known diversity.}

\item{runs}{Number of random permutations to be made to the sampling order. If not specified, default is 100.}

\item{prog}{Present a text progress bar in the R console.}
}
\value{
A matrix of sampling units x diversity values (sampling units, individuals, observed and estimated diversity).
The values provided by this function are:

Sampl - Number of sampling units;

Ind - Number of individuals;

Obs - Observed diversity;

S1 - Singletons;

S2 - Doubletons;

Q1 - Uniques;

Q2 - Duplicates;

Jack1ab - First order jackknife estimator for abundance data;

Jack1in - First order jackknife estimator for incidence data;

Jack2ab - Second order jackknife estimator for abundance data;

Jack2in - Second order jackknife estimator for incidence data;

Chao1 - Chao estimator for abundance data;

Chao2 - Chao estimator for incidence data;

Clench - Clench or Michaelis-Menten curve;

Exponential - Exponential curve;

Rational - Rational function;

Weibull - Weibull curve;

The P-corrected version of all non-parametric estimators is also provided.

Accuracy - if accuracy is to be calculated a list is returned instead, with the second element being the scaled mean squared error of each estimator.
}
\description{
Estimation of alpha diversity of a single site with accumulation of sampling units.
}
\details{
Observed diversity often is an underestimation of true diversity. Several approaches have been devised to estimate species richness (TD) from incomplete sampling.
These include: (1) fitting asymptotic functions to randomised accumulation curves (Soberon & Llorente 1993; Flather 1996; Cardoso et al. in prep.)
(2) the use of non-parametric estimators based on the incidence or abundance of rare species (Heltshe & Forrester 1983; Chao 1984, 1987; Colwell & Coddington 1994).
A correction to non-parametric estimators has also been recently proposed, based on the proportion of singleton or unique species
(species represented by a single individual or in a single sampling unit respectively; Lopez et al. 2012).
Cardoso et al. (2014) have proposed a way of adapting these approaches to estimate PD and FD, also adding a third possible approach for
these dimensions of diversity: (3) correct PD and FD values based on the completeness of TD, where completeness equals the proportion of estimated true diversity that was observed.
Calculations of PD and FD are based on Faith (1992) and Petchey & Gaston (2002, 2006), which measure PD and FD of a community as the total branch length of a tree linking all species represented in such community.
PD and FD are calculated based on a tree (hclust or phylo object, no need to be ultrametric). The path to the root of the tree is always included in calculations of PD and FD.
The number and order of species in comm must be the same as in tree.
}
\examples{
comm <- matrix(c(1,1,0,0,0,0,2,1,0,0,0,0,2,1,0,0,0,0,2,1), nrow = 4, ncol = 5, byrow = TRUE)
tree <- hclust(dist(c(1:5), method="euclidean"), method="average")
alpha.accum(comm)
alpha.accum(comm, func = "nonparametric")
alpha.accum(comm, tree, "completeness")
alpha.accum(comm, tree, "curve", runs = 1000)
alpha.accum(comm, target = -1)
}
\references{
Cardoso, P., Rigal, F., Borges, P.A.V. & Carvalho, J.C. (2014) A new frontier in biodiversity inventory: a proposal for estimators of phylogenetic and functional diversity. Methods in Ecology and Evolution, in press.

Chao, A. (1984) Nonparametric estimation of the number of classes in a population. Scandinavian Journal of Statistics, 11, 265-270.

Chao, A. (1987) Estimating the population size for capture-recapture data with unequal catchability. Biometrics 43, 783-791.

Colwell, R.K. & Coddington, J.A. (1994) Estimating terrestrial biodiversity through extrapolation. Phil. Trans. Roy. Soc. London B 345, 101-118.

Faith, D.P. (1992) Conservation evaluation and phylogenetic diversity. Biological Conservation, 61, 1-10.

Flather, C. (1996) Fitting species-accumulation functions and assessing regional land use impacts on avian diversity. Journal of Biogeography, 23, 155-168.

Heltshe, J. & Forrester, N.E. (1983) Estimating species richness using the jackknife procedure. Biometrics, 39, 1-11.

Lopez, L.C.S., Fracasso, M.P.A., Mesquita, D.O., Palma, A.R.T. & Riul, P. (2012) The relationship between percentage of singletons and sampling effort: a new approach to reduce the bias of richness estimates. Ecological Indicators, 14, 164-169.

Petchey, O.L. & Gaston, K.J. (2002) Functional diversity (FD), species richness and community composition. Ecology Letters, 5, 402-411.

Petchey, O.L. & Gaston, K.J. (2006) Functional diversity: back to basics and looking forward. Ecology Letters, 9, 741-758.

Soberon, M.J. & Llorente, J. (1993) The use of species accumulation functions for the prediction of species richness. Conservation Biology, 7, 480-488.
}
