% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/BAT.R
\name{iaor}
\alias{iaor}
\title{Interspecific abundance-occupancy relationship (IAOR).}
\usage{
iaor(comm)
}
\arguments{
\item{comm}{A sites x species matrix with abundance values.}
}
\value{
A matrix with the different model parameters and explanatory power.
}
\description{
Fits and compares several of the most supported models for the IAOR.
}
\details{
Locally abundant species tend to be widespread while locally rare species tend to be narrowly distributed.
That is, for a given species assemblage, there is a positive interspecific abundance-occupancy relationship (Brown 1984).
This function compares some of the most commonly used and theoretically or empirically suported models (Nachman 1981; He & Gaston 2000; Cardoso et al. subm.).
}
\examples{
comm <- matrix(c(4,3,2,1,5,4,3,2,3,2,1,0,6,3,0,0,0,0,0,0), nrow = 5, ncol = 4, byrow = TRUE)
iaor(comm)
}
\references{
Brown, J.H. (1984) On the relationship between abundance and distribution of species. American Naturalist, 124: 255-279.

Cardoso, P., Borges, P.A.V., Carvalho, J.C., Rigal, F., Gabriel, R., Cascalho, J. & Correia, L. (subm.) Automated discovery of relationships, models and principles in ecology. Pre-print available from bioRxiv doi: http://dx.doi.org/10.1101/027839

He, F.L. & Gaston, K.J. (2000) Estimating species abundance from occurrence. American Naturalist, 156: 553-559.

Nachman, G. (1981) A mathematical model of the functional relationship between density and spatial distribution of a population. Journal of Animal Ecology, 50: 453-460.
}

