% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.bas}
\alias{summary.bas}
\alias{summary}
\title{Summaries of Bayesian Model Averaging objects from BAS}
\usage{
\method{summary}{bas}(object, n.models = 5, ...)
}
\arguments{
\item{object}{object of class 'bas'}

\item{n.models}{optional number specifying the number of best models to
display in summary}

\item{...}{other parameters to be passed to \code{summary.default}}
}
\description{
\code{summary} and \code{print} methods for Bayesian model averaging objects
created by \code{bas} Bayesian Adaptive Sampling
}
\details{
The print methods display a view similar to \code{print.lm} .  The summary
methods display a view specific to Bayesian model averaging giving the top 5
highest probability models represented by their inclusion indicators.
Summaries of the models include the Bayes Factor (BF) of each model to the
model with the largest marginal likelihood, the posterior probability of the
models, R2, dim (which includes the intercept) and the log of the marginal
likelihood.
}
\examples{
data(UScrime, package = "MASS")
UScrime[, -2] <- log(UScrime[, -2])
crime.bic <- bas.lm(y ~ ., data = UScrime, n.models = 2^15, prior = "BIC", initprobs = "eplogp")
print(crime.bic)
summary(crime.bic)
}
\seealso{
\code{\link{coef.bas}}

Other bas methods: 
\code{\link{BAS}},
\code{\link{bas.lm}()},
\code{\link{coef.bas}()},
\code{\link{confint.coef.bas}()},
\code{\link{confint.pred.bas}()},
\code{\link{diagnostics}()},
\code{\link{fitted.bas}()},
\code{\link{force.heredity.bas}()},
\code{\link{image.bas}()},
\code{\link{plot.confint.bas}()},
\code{\link{predict.basglm}()},
\code{\link{predict.bas}()},
\code{\link{update.bas}()},
\code{\link{variable.names.pred.bas}()}
}
\author{
Merlise Clyde \email{clyde@duke.edu}
}
\concept{bas methods}
\keyword{print}
\keyword{regression}
