% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohorts.R
\name{cohorts}
\alias{cohorts}
\title{Visualize macroevolutionary cohorts}
\usage{
cohorts(x, ephy, col, pal, lwd = 1, ofs = 0, use.plot.bammdata = FALSE,
  useraster = FALSE, LARGE = 500, ...)
}
\arguments{
\item{x}{A matrix of pairwise correlations generated by
\code{getCohortMatrix}.}

\item{ephy}{An object of class \code{bammdata}.}

\item{col}{A vector of colors passed to the function \code{image}. These
will be used to color the values in \code{x}. See documentation for
\code{image}. If \code{col = 'temperature'}, the color palette from
\code{\link{rich.colors}} from the gplots package will be used.}

\item{pal}{The palette to use if \code{use.plot.bammdata=TRUE}. See
options documented in the help file for \code{\link{plot.bammdata}}.}

\item{lwd}{A numeric indicating the width of branches in the phylogeny.}

\item{ofs}{A numeric controlling the offset of the phylogeny from the
matrix plot. Appropriate values will probably be in the interval
[0,0.1].}

\item{use.plot.bammdata}{Logical. should a phylorate plot be generated?}

\item{useraster}{A logical indicating whether the function \code{image}
should plot the matrix as a raster.}

\item{LARGE}{An integer. If trees have more tips than \code{LARGE},
\code{useraster} will be coerced to \code{TRUE}.}

\item{\dots}{Further arguments passed to \code{plot.bammdata} if
\code{use.plot.bammdata=TRUE}.}
}
\description{
Plots the matrix of pairwise correlations in rate regimes
    between all tips in a phylogeny.
}
\details{
The plotting function creates an image of the \code{BAMM}
    correlation matrix between tip lineages of the phylogeny. Each
    correlation is the posterior frequency with which a pair of lineages
    occurs in the same macroevolutionary rate regime. Correlations are
    mapped to a set of colors, with warmer colors corresponding to higher
    correlations than cooler colors. The set of colors is specified by the
    \code{col} argument and a legend is plotted to guide interpretation of
    the color-correlation map. Trees are plotted on the margins of the
    matrix image. The correlation between any two tips can be inferred by
    finding their intersection within the matrix image.

    \strong{IMPORTANT}: the legend DOES NOT apply to the phylorate plots
    shown in the margin if \code{use.plot.bammdata=TRUE}.
}
\examples{
data(whales, events.whales)
ed <- getEventData(whales, events.whales, burnin=0.1, nsamples=500)
x <- getCohortMatrix(ed)
cohorts(x, ed)
cohorts(x, ed, col='temperature')
cohorts(x, ed, ofs=0.05, col='temperature')
cohorts(x, ed, pal="temperature", col='temperature', use.plot.bammdata=TRUE)
# gray scale
cohorts(x, ed, col=gray(seq(0.2,0.9,length.out=128)),
        use.plot.bammdata=FALSE)
}
\author{
Mike Grundler
}
\seealso{
\code{\link{plot.bammdata}}, \code{\link{getCohortMatrix}},
    \code{\link{image}}
}

