% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/container.R
\name{storage_queue}
\alias{storage_queue}
\alias{storage_queue.character}
\alias{storage_queue.queue_endpoint}
\alias{list_storage_queues}
\alias{list_storage_queues.character}
\alias{list_storage_queues.queue_endpoint}
\alias{list_storage_containers.queue_endpoint}
\alias{create_storage_queue}
\alias{create_storage_queue.character}
\alias{create_storage_queue.queue_endpoint}
\alias{create_storage_queue.StorageQueue}
\alias{delete_storage_queue}
\alias{delete_storage_queue.character}
\alias{delete_storage_queue.queue_endpoint}
\alias{delete_storage_queue.StorageQueue}
\title{Message queues}
\usage{
storage_queue(endpoint, ...)

\method{storage_queue}{character}(
  endpoint,
  key = NULL,
  token = NULL,
  sas = NULL,
  api_version = getOption("azure_storage_api_version"),
  ...
)

\method{storage_queue}{queue_endpoint}(endpoint, name, ...)

list_storage_queues(endpoint, ...)

\method{list_storage_queues}{character}(
  endpoint,
  key = NULL,
  token = NULL,
  sas = NULL,
  api_version = getOption("azure_storage_api_version"),
  ...
)

\method{list_storage_queues}{queue_endpoint}(endpoint, ...)

\method{list_storage_containers}{queue_endpoint}(endpoint, ...)

create_storage_queue(endpoint, ...)

\method{create_storage_queue}{character}(
  endpoint,
  key = NULL,
  token = NULL,
  sas = NULL,
  api_version = getOption("azure_storage_api_version"),
  ...
)

\method{create_storage_queue}{queue_endpoint}(endpoint, name, ...)

\method{create_storage_queue}{StorageQueue}(endpoint, ...)

delete_storage_queue(endpoint, ...)

\method{delete_storage_queue}{character}(
  endpoint,
  key = NULL,
  token = NULL,
  sas = NULL,
  api_version = getOption("azure_storage_api_version"),
  ...
)

\method{delete_storage_queue}{queue_endpoint}(endpoint, name, ...)

\method{delete_storage_queue}{StorageQueue}(endpoint, confirm = TRUE, ...)
}
\arguments{
\item{endpoint}{Either a queue endpoint object as created by \link{storage_endpoint}, or a character string giving the URL of the endpoint.}

\item{...}{Further arguments passed to lower-level functions.}

\item{key, token, sas}{If an endpoint object is not supplied, authentication credentials: either an access key, an Azure Active Directory (AAD) token, or a SAS, in that order of priority.}

\item{api_version}{If an endpoint object is not supplied, the storage API version to use when interacting with the host. Currently defaults to \code{"2019-07-07"}.}

\item{name}{The name of the queue to get, create, or delete.}

\item{confirm}{For deleting a queue, whether to ask for confirmation.}
}
\value{
For \code{storage_queue} and \code{create_storage_queue}, an object of class \code{\link{StorageQueue}}. For \code{list_storage_queues}, a list of such objects.
}
\description{
Get, list, create, or delete queues.
}
\details{
You can call these functions in a couple of ways: by passing the full URL of the storage queue, or by passing the endpoint object and the name of the share as a string.
}
\examples{
\dontrun{

endp <- storage_endpoint("https://mystorage.queue.core.windows.net", key="key")

# to talk to an existing queue
queue <- storage_queue(endp, "queue1")

# to create a new queue
queue2 <- create_storage_queue(endp, "queue2")

# various ways to delete a queue (will ask for confirmation first)
queue2$delete()
delete_storage_queue(queue2)
delete_storage_queue(endp, "queue2")
}
}
\seealso{
\code{\link{StorageQueue}}, \code{\link{queue_endpoint}}
}
