% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cert_creds.R
\name{cert_assertion}
\alias{cert_assertion}
\title{Create a client assertion for certificate authentication}
\usage{
cert_assertion(certificate, duration = 3600, signature_size = 256, ...)
}
\arguments{
\item{certificate}{An Azure Key Vault certificate object, or the name of a PEM or PFX file containing \emph{both} a private key and a public certificate.}

\item{duration}{The requested validity period of the token, in seconds. The default is 1 hour.}

\item{signature_size}{The size of the SHA2 signature.}

\item{...}{Other named arguments which will be treated as custom claims.}
}
\value{
An object of S3 class \code{cert_assertion}, which is a list representing the assertion.
}
\description{
Create a client assertion for certificate authentication
}
\details{
Use this function to customise a client assertion for authenticating with a certificate.
}
\examples{
\dontrun{

cert_assertion("mycert.pem", duration=2*3600)
cert_assertion("mycert.pem", custom_data="some text")

# using a cert stored in Azure Key Vault
cert <- AzureKeyVault::key_vault("myvault")$certificates$get("mycert")
cert_assertion(cert, duration=2*3600)

} 
}
\seealso{
\link{get_azure_token}
}
