% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AsyK.R
\name{plot.Laplace}
\alias{plot.Laplace}
\title{Density Plot by Laplace kernel}
\usage{
\method{plot}{Laplace}(x, ...)
}
\arguments{
\item{x}{an object of class "Laplace"}

\item{\dots}{Not presently used in this implementation}
}
\value{
nothing
}
\description{
Plot density by using Laplace Kernel.
}
\examples{
y <- rexp(100,1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
den <- Laplace(y, 200, h)
plot(den, type = "s", ylab = "Density Function", lty = 1, xlab = "Time")
d1 <- density(y, bw=h)
lines(d1,type="p",col="red")
legend("topright", c("Real Density", "Density by Laplace Kernel"), col=c("red", "black"))
}
\references{
Khan, J. A.; Akbar, A. Density Estimation by Laplace Kernel. \emph{Working paper,  Department of Statistics, Bahauddin Zakariya University, Multan, Pakistan.}
}
\seealso{
To examine Laplace estimated values for density see \code{\link{Laplace}} and for Mean Squared Error \code{\link{mseLap}}. Similarly, for plot of Laplace kernel \code{\link{plot.RIG}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
