% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MAX3_main.R
\name{max3}
\alias{max3}
\title{Maximum Test: maximal value of the three Cochran-Armitage
trend tests under the recessive, additive, and dominant models}
\usage{
max3(y, g, covariates = NULL, Score.test = TRUE, Wald.test = FALSE,
  rhombus.formula = FALSE)
}
\arguments{
\item{y}{a numeric vector of the observed trait values in which
the \emph{i}th element is for the \emph{i}th subject. The elements
should be 0 or 1.}

\item{g}{a numeric vector of the observed genotype values (0, 1,
or 2 denotes the number of risk alleles) in which the \emph{i}th
element is for the \emph{i}th subject.  The missing value is
represented by NA. \code{g} has the same length as \code{y}.}

\item{covariates}{a numeric matrix for the covariates used in the
model. Each column is for one covariate. The default is NULL, that
is, there are no covariates to be adjusted for.}

\item{Score.test}{logical. If TRUE, the score tests are used. One
of the \code{Score.test} and the \code{Wald.test} should be FALSE,
and the other should be TRUE. The default is TRUE.}

\item{Wald.test}{logical. If TRUE, the Wald tests are used. One of
the \code{Score.test} and the \code{Wald.test} should be FALSE,
and the other should be TRUE. The default is FALSE.}

\item{rhombus.formula}{logical. If TRUE, The p-value for the MAX3
is approximated by the rhombus formula. IF FALSE, the 2-fold
integration is used to calculate the p-value. The default is
FALSE.}
}
\value{
A list of \code{test.stat} and
\code{p.val}. \code{test.stat} is the observed value of the test
statistic and \code{p.val} is the p-value of the test.
}
\description{
Conduct MAX3 (the maximal value of the three Cochran-Armitage
trend tests derived for the recessive, additive, and dominant
models) based on the trend tests without the adjustment of the
covariates or based on the Wald tests with the adjustment of the
covariates to test for the association between a single-nucleotide
polymorphism and the binary phenotype.
}
\details{
In an association study, the genetic inheritance models
(recessive, additive, or dominant) are unknown beforehand. This
function can account for the uncertainty of the underlying genetic
models and test for the association between a single-nucleotide
polymorphism and a binary phenotype with or without correcting for
the covariates.
}
\examples{
y <- rep(c(0, 1), 5)
g <- sample(c(0, 1, 2), 10, replace = TRUE)
max3(y, g, covariates = NULL, Score.test = TRUE, Wald.test = FALSE,
       rhombus.formula = FALSE)
max3(y, g, covariates = matrix(sample(c(0,1), 20, replace = TRUE), ncol=2),
       Score.test = TRUE, Wald.test = FALSE, rhombus.formula = FALSE)
}
\author{
Lin Wang, Wei Zhang, and Qizhai Li.
}
\references{
Q Li, G Zheng, Z Li, and K Yu. Efficient approximation
of p-value of the maximum of correlated tests, with applications
to genome-wide association studies. \emph{Annals of Human
Genetics}. 2008; 72(3): 397-406.
}

