#' @name Arothron-package
#' @docType package
#' @aliases Arothron
#' @title eometric Morphometric Methods and Virtual Anthropology Tools
#' @author Antonio Profico, Costantino Buzi, Silvia Castiglione, Marina Melchionna, Paolo Piras, Pasquale Raia, Alessio Veneziano
#' @description Tools for geometric morphometric analysis. The package includes tools of virtual anthropology to align two not articulated parts belonging to the same specimen, to build virtual cavities as endocast (Profico et al, 2018 <doi:10.1002/ajpa.23493>).
#' @import alphashape3d
#' @import doParallel
#' @import foreach
#' @import geometry
#' @import graphics
#' @import grDevices
#' @import methods
#' @import Morpho
#' @import parallel
#' @import rgl
#' @import Rvcg
#' @import stats
#' @import stringr
#' @import utils
#' @importFrom abind abind
#' @importFrom alphashape3d ashape3d
#' @importFrom parallel detectCores
#' @importFrom grDevices dev.new rainbow
#' @importFrom methods is
#' @importFrom rgl as.mesh3d
#' @importFrom stats dist kmeans rnorm
#' @importFrom utils read.table write.table
#' @importFrom vegan procrustes
#' @importFrom compositions plot3D
#' @importFrom Rvcg checkFaceOrientation
#' @importFrom stats4 mle

NULL
