% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/allen-mcmc.R
\docType{methods}
\name{allen_joint_concurrency}
\alias{allen_joint_concurrency}
\alias{allen_joint_concurrency-method}
\alias{allen_joint_concurrency,EventsMCMC,list-method}
\title{Joint Concurrence of Two or More Observed Intervals}
\usage{
allen_joint_concurrency(x, groups, ...)

\S4method{allen_joint_concurrency}{EventsMCMC,list}(x, groups, ...)
}
\arguments{
\item{x}{An \code{\linkS4class{EventsMCMC}} object containing
the output of the MCMC algorithm.}

\item{groups}{A \code{\link{list}} of (named) vector of names or indexes of columns in
\code{x} (see \code{\link[=phases]{phases()}}).}

\item{...}{Currently not used.}
}
\value{
A \code{\linkS4class{PhasesMCMC}} object.
}
\description{
Estimates the age of an undated context based on the known depositional
history of associated artifacts.
}
\seealso{
Other Allen's intervals: 
\code{\link{allen_analyze}()},
\code{\link{allen_complement}()},
\code{\link{allen_composition}()},
\code{\link{allen_converse}()},
\code{\link{allen_illustrate}()},
\code{\link{allen_intersect}()},
\code{\link{allen_observe}()},
\code{\link{allen_observe_frequency}()},
\code{\link{allen_relation}()},
\code{\link{allen_relation_code}()},
\code{\link{allen_union}()}
}
\author{
T. S. Dye
}
\concept{Allen's intervals}
