% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiPhasePlot.R
\name{MultiPhasePlot}
\alias{MultiPhasePlot}
\title{Several phase density plots}
\usage{
MultiPhasePlot(
  data,
  position_minimum,
  position_maximum = position_minimum + 1,
  level = 0.95,
  title = "Characterisation of several groups",
  colors = NULL,
  exportFile = NULL,
  exportFormat = "PNG"
)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{position_minimum}{Numeric vector containing the column number
corresponding to the minimum of the events included in each group.}

\item{position_maximum}{Numeric vector containing the column number
corresponding to the end of the groups set in the same order as in
\code{position_minimum}.}

\item{level}{Probability corresponding to the level of confidence.}

\item{title}{Title of the plot.}

\item{colors}{Numeric vector of colors for each group of dates.}

\item{exportFile}{Name of the file to be saved. If \code{NULL} then
no plot is saved.}

\item{exportFormat}{Format of the export file, one of "PNG" or "SVG".}
}
\value{
\code{NULL}, called for its side effects
}
\description{
Plot of the marginal posterior densities of several groups
}
\details{
Draws a plot with the marginal posterior densities of the minimum
and the maximum of the dates included in each group. No temporal
order between phases is required. The result is given in calendar
years (BC/AD).
}
\examples{
  # Data extracted from ChronoModel software
  data(Phases)
  # List of the name of the groups
  names(Phases)
  # Stipulating position_maximum
  MultiPhasePlot(Phases, c(4, 2), c(5, 3), title = "Succession of phase 1 and phase 2")
  # In this case, equivalent to
  MultiPhasePlot(Phases, c(4, 2), title = "Succession of phase 1 and phase 2", colors = c(3, 4))

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
