% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImportCSV.R
\name{read_chronomodel}
\alias{read_chronomodel}
\title{Read MCMC output from ChronoModel}
\usage{
read_chronomodel(file, decimal = ".", separator = ",", quiet = "no")
}
\arguments{
\item{file}{Either a path to a CSV file, a connection,
or the value \code{clipboard()} to read from the system clipboard.
The CSV file can be compressed or plain.
See \code{\link[readr]{read_delim}} for details.}

\item{decimal}{Either "." (default) or ",",
the two choices offered by
\href{https://chronomodel.com/}{ChronoModel}.}

\item{separator}{The character used to separate fields
in the CSV file.  Defaults to ",".}

\item{quiet}{One of "no" (default) to allow messages and warnings, "partial"
to suppress messages and allow warnings, or "yes" to suppress messages
and warnings.}
}
\value{
An \code{archaeophases_mcmc} object containing the marginal
posterior(s) from file.
}
\description{
Import a CSV file containing the output of the MCMC algorithm produced
by \href{https://chronomodel.com/}{ChronoModel}.
}
\details{
The \code{read_chronomodel} function is built on
\code{\link[readr]{read_delim}}.
It aims to be fast and simple, and to return the marginal posteriors
free of extraneous artifacts.  The iteration column in the CSV file is
discarded.
}
\examples{

  data(Events)
\dontrun{
  write.csv(Events, "events.csv", row.names=FALSE)
  events = read_chronomodel("events.csv", decimal = ".", separator = ",")
  # equivalent
  events = read_chronomodel("events.csv")


   rem <- read_chronomodel("http://tsdye.online/AP/cm/Chain_all_Events.csv")
 }

}
\seealso{
\code{\link[readr]{read_delim}}

\code{\link{ImportCSV}}

\code{\link{new_archaeophases_mcmc}}
}
\author{
Thomas S. Dye, \email{tsd@tsdye.online}
}
