% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiDatesPlot.R
\name{MultiDatesPlot}
\alias{MultiDatesPlot}
\title{Plot of credible intervals or HPD regions of a series of events}
\usage{
MultiDatesPlot(
  data,
  position,
  level = 0.95,
  roundingOfValue = 0,
  intervals = "CI",
  order = "default",
  title = "Plot of intervals",
  subtitle = NULL,
  caption = "ArchaeoPhases",
  labelXaxis = "Calendar Year",
  labelYaxis = NULL,
  height = 7,
  width = 7,
  units = "in",
  x.min = NULL,
  x.max = NULL,
  x.scale = "calendar",
  elapsed.origin.position = NULL,
  dumbbell.size = 3,
  dot.guide = FALSE,
  dot.guide.size = 0.25,
  y.grid = FALSE,
  file = NULL,
  newWindow = TRUE,
  print.data.result = FALSE
)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{position}{Numeric vector containing the position of the column
corresponding to the MCMC chains of interest.}

\item{level}{Probability corresponding to the level of confidence.}

\item{roundingOfValue}{Integer indicating the number of decimal places to be used.}

\item{intervals}{One of "CI" for credible intervals, or "HPD" for highest
posterior density intervals.}

\item{order}{Order of the events. If "default" then the order of the csv file
is followed, if "increasing" events are ordered by the HPDInf of the
first region or the CIInf}

\item{title}{Title of the plot.}

\item{subtitle}{Subtitle of the plot.}

\item{caption}{Caption of the plot.}

\item{labelXaxis}{X axis label of the plot.}

\item{labelYaxis}{Y axis label of the plot.}

\item{height}{Height of the plot in \code{units}.}

\item{width}{Width of the plot in \code{units}.}

\item{units}{A string recognized by \code{ggsave()} function,
one of "in", "cm", "mm".}

\item{x.min}{Minimum x axis value.}

\item{x.max}{Maximum x axis value.}

\item{x.scale}{One of "calendar" for calendar years,
"BP" for years before present,
or "elapsed" for years after a specified origin.}

\item{elapsed.origin.position}{Position of the column corresponding
to the origin for elapsed time calculations.}

\item{dumbbell.size}{Size of the symbols used to plot events.}

\item{dot.guide}{Switch for guides from y-axis to plot symbols.}

\item{dot.guide.size}{Size of the dot guides.}

\item{y.grid}{Switch for horizontal grids.}

\item{file}{Name of the file to be saved. If \code{NULL} then no plot is saved.}

\item{newWindow}{Whether the plot is drawn within a new window or not.}

\item{print.data.result}{If \code{TRUE}, the list containing the data to plot
will be returned.}
}
\value{
NULL, called for its side effects.  If \code{print.data.result = TRUE}
then a list containing the data to plot will be returned.
}
\description{
Plot of credible intervals or HPD regions of a series of events
}
\examples{
  data(Events)
  MultiDatesPlot(Events, c(2, 4, 3), level = 0.95, intervals = "CI",
                 title = "Plot of CI intervals")
  MultiDatesPlot(Events, c(2, 4, 3), level = 0.95, intervals = "HPD",
                 title = "Plot of HPD intervals")
  MultiDatesPlot(Events, c(2, 4, 3), level = 0.95, intervals = "HPD",
                 order = "increasing")

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr},

Thomas S. Dye, \email{tsd@tsdye.online}, and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
