% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Af_metrics.R
\name{Af_metrics}
\alias{Af_metrics}
\title{Function to calculate metrics for each tree in an AntibodyForests-object}
\usage{
Af_metrics(
  input,
  min.nodes,
  node.feature,
  group.node.feature,
  multiple.objects,
  metrics,
  parallel,
  num.cores,
  output.format
)
}
\arguments{
\item{input}{AntibodyForests-object(s), output from Af_build()}

\item{min.nodes}{The minimum number of nodes in a tree to calculate metrics (including the germline).}

\item{node.feature}{The node feature to be used for the group.edge.length or group.nodes.depth metric.}

\item{group.node.feature}{The groups in the node feature to be plotted. Set to NA if all features should displayed. (default NA)}

\item{multiple.objects}{If TRUE: input should contain multiple AntibodyForests-objects (default FALSE)}

\item{metrics}{The metrics to be calculated (default mean.depth and nr.nodes)
'nr.nodes'         : The total number of nodes
'nr.cells'         : The total number of cells in this clonotype
'mean.depth'       : Mean of the number of edges connecting each node to the germline
'mean.edge.length' : Mean of the edge lengths between each node and the germline
'group.node.depth'      : Mean of the number of edges connecting each node per group (node.features of the AntibodyForests-object) to the germline. (default FALSE)
'group.edge.length'    : Mean of the sum of edge length of the shortest path between germline and nodes per group (node.features of the AntibodyForests-object)
'sackin.index'     : Sum of the number of nodes between each terminal node and the germline, normalized by the total number of terminal nodes.
'spectral.density' : Metrics of the spectral density profiles (calculated with package RPANDA)
\itemize{
\item peakedness            : Tree balance
\item asymmetry             : Shallow or deep branching events
\item principal eigenvalue  : Phylogenetic diversity
\item modalities            : The number of different structures within the tree
}}

\item{parallel}{If TRUE, the metric calculations are parallelized (default FALSE)}

\item{num.cores}{Number of cores to be used when parallel = TRUE. (Defaults to all available cores - 1)}

\item{output.format}{The format of the output. If set to "dataframe", a dataframe is returned. If set to "AntibodyForests", the metrics are added to the AntibodyForests-object. (default "dataframe")}
}
\value{
Returns either a dataframe where the rows are trees and the columns are metrics or an AntibodyForests-object with the metrics added to trees
}
\description{
Function to calculate metrics for each tree in an AntibodyForests-object
}
\examples{
metric_df <- Af_metrics(input = AntibodyForests::small_af,
                        metrics = c("mean.depth", "sackin.index"),
                        min.nodes = 8)
head(metric_df)
}
