% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GabrielTest.R
\name{GabrielTest}
\alias{GabrielTest}
\title{Gabriel’s Post Hoc Test for Multiple Comparisons v 2.0}
\usage{
GabrielTest(modelo, comparar = NULL, alpha = 0.05)
}
\arguments{
\item{modelo}{An \code{aov} or \code{lm} object (full model: includes blocks, factors, etc.).}

\item{comparar}{Character vector with the name(s) of the factor(s) to compare:
- One name: main effect (e.g., "treatment" or "A")
- Several names: interaction (e.g., \code{c("A","B")} for \code{A:B})
If omitted, it uses the first factor in \code{modelo$xlevels}.}

\item{alpha}{Significance level (default 0.05).}
}
\value{
An object of class \code{"gabriel"} and \code{"comparaciones"} containing:
\itemize{
  \item \code{Resultados}: a data.frame with columns \code{Comparacion}, \code{Diferencia}, \code{SE}, \code{t_value},
        \code{p_value} (unadjusted), \code{p_ajustada} (gabriel), \code{Valor_Critico} (critical difference), and \code{Significancia}.
  \item \code{Promedios}: a named vector of group means as defined by \code{comparar}.
  \item \code{Orden_Medias}: group names ordered from highest to lowest mean.
  \item \code{Metodo}: "Gabriel t-test".
  \item \code{Termino}: the term being compared (e.g., "A", "B", or "A:B").
  \item \code{MSerror}, \code{df_error}, \code{N}: useful for plots with error bars.
}
}
\description{
A modification of Tukey's test for use with moderately unequal sample sizes.
}
\details{
Advantages:
- More powerful than Tukey for unequal group sizes.
- Controls error rates effectively with moderate imbalance.

Disadvantages:
- Can be anti-conservative with large differences in group sizes.
- Less common in standard statistical software.
}
\examples{

# DCA
data(d_e, package = "Analitica")
mod1 <- aov(Sueldo_actual ~ as.factor(labor), data = d_e)
resultado <- GabrielTest(mod1)
summary(resultado)
plot(resultado)

# RCBD
mod2 <- aov(Sueldo_actual ~ as.factor(labor) + Sexo, data = d_e)
res <- GabrielTest(mod2, comparar = "as.factor(labor)")
summary(res); plot(res)

# Factorial
mod3 <- aov(Sueldo_actual ~ as.factor(labor) * Sexo, data = d_e)
resAB <- GabrielTest(mod3, comparar = c("as.factor(labor)","Sexo"))  # celdas A:B
summary(resAB, n = Inf); plot(resAB, horizontal = TRUE)

}
\references{
Hochberg, Y., & Tamhane, A. C. (1987). Multiple Comparison Procedures.
}
