% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomeObject.R
\name{getCodonCountsForAA}
\alias{getCodonCountsForAA}
\title{Get Codon Counts For a specific Amino Acid}
\usage{
getCodonCountsForAA(aa, genome)
}
\arguments{
\item{aa}{One letter code of the amino acid for which the codon counts should be returned}

\item{genome}{A genome object from which the counts of each
codon can be obtained.}
}
\value{
Returns a data.frame storing the codon counts for the specified amino acid.
}
\description{
provides the codon counts for a fiven amino acid across all genes
}
\details{
The returned matrix containes a row for each gene and a coloumn 
for each synonymous codon of \code{aa}.
}
\examples{

genome_file <- system.file("extdata", "genome.fasta", package = "AnaCoDa")
 
## reading genome
genome <- initializeGenomeObject(file = genome_file)
counts <- getCodonCountsForAA("A", genome)

}
