% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcObject.R
\name{convergence.test}
\alias{convergence.test}
\title{Convergence Test}
\usage{
convergence.test(object, samples = 10, frac1 = 0.1, frac2 = 0.5,
  thin = 1, plot = FALSE, what = "Mutation", mixture = 1)
}
\arguments{
\item{object}{an object of either class Trace or MCMC}

\item{samples}{number of samples at the end of the trace used to determine convergence (< length of trace). 
Will use as starting point of convergence test. If the MCMC trace
is of length x, then starting point for convergence test will be x - samples.}

\item{frac1}{fraction to use from beginning of samples}

\item{frac2}{fraction to use from end of samples}

\item{thin}{the thinning interval between consecutive observations, which is used in creating a coda::mcmc object (according to the Coda documentation, users should specify if a MCMC chain has already been thinned using a the thin parameter). This does not further thin the data.}

\item{plot}{(logical) plot result instead of returning an object}

\item{what}{(for Trace Object only) which parameter to calculate convergence.test -- current options are Selection, Mutation, MixtureProbability, Sphi, Mphi, ExpectedPhi, and AcceptanceCSP}

\item{mixture}{(for Trace Object only) mixture for which to calculate convergence.test}
}
\value{
Geweke score object evaluating whether means of two fractions (frac1 and frac2) differ.  Convergence occurs when they don't differ significantly, i.e. pnorm(abs(convergence.test(mcmcObj)$a, ,lower.tail=FALSE)*2 > 0.05
}
\description{
Convergence Test
}
\details{
Be aware that convergence.test for Trace objects works primarily for Trace objects from the ROC parameter class. Future updates will adapt this function to work for parameters from other models and expression traces
}
\examples{

## check for convergence after a run:

genome_file <- system.file("extdata", "genome.fasta", package = "AnaCoDa")

genome <- initializeGenomeObject(file = genome_file)
sphi_init <- c(1,1)
numMixtures <- 2
geneAssignment <- c(rep(1,floor(length(genome)/2)),rep(2,ceiling(length(genome)/2)))
parameter <- initializeParameterObject(genome = genome, sphi = sphi_init, 
                                       num.mixtures = numMixtures, 
                                       gene.assignment = geneAssignment, 
                                       mixture.definition = "allUnique")
samples <- 2500
thinning <- 50
adaptiveWidth <- 25
mcmc <- initializeMCMCObject(samples = samples, thinning = thinning, 
                             adaptive.width=adaptiveWidth, est.expression=TRUE, 
                             est.csp=TRUE, est.hyper=TRUE, est.mix = TRUE) 
divergence.iteration <- 10
\dontrun{
runMCMC(mcmc = mcmc, genome = genome, model = model, 
        ncores = 4, divergence.iteration = divergence.iteration)
# check if posterior trace has converged
convergence.test(object = mcmc, samples = 500, plot = TRUE)

trace <- getTrace(parameter)
# check if Mutation trace has converged
convergence.test(object = trace, samples = 500, plot = TRUE, what = "Mutation")
# check if Sphi trace has converged
convergence.test(object = trace, samples = 500, plot = TRUE, what = "Sphi")
# check if ExpectedPhi trace has converged
convergence.test(object = trace, samples = 500, plot = TRUE, what = "ExpectedPhi")
}
}
