% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GS.R
\name{setEBV}
\alias{setEBV}
\title{Set estimated breeding values (EBV)}
\usage{
setEBV(
  pop,
  solution,
  value = "gv",
  targetPop = NULL,
  append = FALSE,
  simParam = NULL
)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{solution}{an object of \code{\link{RRsol-class}}}

\item{value}{the genomic value to be estimated. Can be
either "gv", "bv", "female", or "male".}

\item{targetPop}{an optional target population that can
be used when value is "bv", "female", or "male". When
supplied, the allele frequency in the targetPop is used
to set these values.}

\item{append}{should estimated values be appended to
existing data in the EBV slot. If TRUE, a new column is
added. If FALSE, existing data is replaced with the
new estimates.}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns an object of \code{\link{Pop-class}}
}
\description{
Adds genomic estimated values to a populations's EBV
slot using output from a genomic selection functions.
The genomic estimated values can be either estimated
breeding values, estimated genetic values, or
estimated general combining values.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=20)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(10)
SP$setVarE(h2=0.5)
SP$addSnpChip(10)

#Create population
pop = newPop(founderPop, simParam=SP)

#Run GS model and set EBV
ans = RRBLUP(pop, simParam=SP)
pop = setEBV(pop, ans, simParam=SP)

#Evaluate accuracy
cor(gv(pop), ebv(pop))

}
