% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection.R
\name{selectInd}
\alias{selectInd}
\title{Select individuals}
\usage{
selectInd(pop, nInd, trait = 1, use = "pheno", gender = "B",
  selectTop = TRUE, returnPop = TRUE, candidates = NULL,
  simParam = NULL, ...)
}
\arguments{
\item{pop}{and object of \code{\link{Pop-class}} or 
\code{\link{HybridPop-class}}}

\item{nInd}{the number of individuals to select}

\item{trait}{the trait for selection. Either a number indicating 
a single trait or a function returning a vector of length nInd.}

\item{use}{select on genetic values "gv", estimated
breeding values "ebv", breeding values "bv", phenotypes "pheno", 
or randomly "rand"}

\item{gender}{which gender to select. Use "B" for both, "F" for 
females and "M" for males. If the simulation is not using gender, 
the argument is ignored.}

\item{selectTop}{selects highest values if true. 
Selects lowest values if false.}

\item{returnPop}{should results be returned as a 
\code{\link{Pop-class}}. If FALSE, only the index of selected 
individuals is returned.}

\item{candidates}{an optional vector of eligible selection candidates.}

\item{simParam}{an object of \code{\link{SimParam}}}

\item{...}{additional arguments if using a function for 
trait}
}
\value{
Returns an object of \code{\link{Pop-class}} or 
\code{\link{HybridPop-class}}
}
\description{
Selects a subset of nInd individuals from a 
population.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)
SP$setVarE(h2=0.5)

#Create population
pop = newPop(founderPop, simParam=SP)

#Select best 5
pop2 = selectInd(pop, 5, simParam=SP)

}
