% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParam.R
\name{SimParam_resetPed}
\alias{SimParam_resetPed}
\title{Reset pedigree}
\arguments{
\item{lastId}{last ID to include in pedigree}
}
\description{
Resets the internal lastId, the pedigree 
and recombination tracking, if it is being used, to the 
supplied lastId. Be careful using this function because 
it may introduce bug if you supsequently use individuals 
that come from a portion the pedigree that is being reset.
}
\section{Usage}{
 SP$resetPed(lastId = 0L)
}

\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)

#Create population
pop = newPop(founderPop, simParam=SP)
pop@id # 1:10

#Create another population after reseting pedigree
SP$resetPed()
pop2 = newPop(founderPop, simParam=SP)
pop2@id # 1:10

}
