% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{DGP}
\alias{DGP}
\title{Data Generating Process}
\usage{
DGP(
  anno = NULL,
  beta = c(0, 1, 2),
  binary = FALSE,
  geno = NULL,
  include_residual = TRUE,
  indicator = FALSE,
  maf_range = c(0.005, 0.01),
  method = "none",
  n = 100,
  p_dmv = 0.4,
  p_ptv = 0.1,
  prop_causal = 1,
  random_signs = FALSE,
  random_var = 0,
  snps = 100,
  weights = c(1, 2, 3)
)
}
\arguments{
\item{anno}{Annotation vector, if providing genotypes. Should match the
number of columns in geno.}

\item{beta}{If method = "none", a (3 x 1) coefficient vector for bmvs, dmvs,
and ptvs respectively. If method != "none", a scalar effect size.}

\item{binary}{Generate binary phenotype? Default: FALSE.}

\item{geno}{Genotype matrix, if providing genotypes.}

\item{include_residual}{Include residual? If FALSE, returns the expected
value. Intended for testing.}

\item{indicator}{Convert raw counts to indicators? Default: FALSE.}

\item{maf_range}{Range of minor allele frequencies: c(MIN, MAX).}

\item{method}{Genotype aggregation method. Default: "none".}

\item{n}{Sample size.}

\item{p_dmv}{Frequency of deleterious missense variants. Default of 40\% is
based on the frequency of DMVs among rare coding variants in the UK
Biobank.}

\item{p_ptv}{Frequency of protein truncating variants. Default of 10\% is
based on the frequency of PTVs among rare coding variants in the UK
Biobank.}

\item{prop_causal}{Proportion of variants which are causal. Default: 1.0.}

\item{random_signs}{Randomize signs? FALSE for burden-type genetic
architecture, TRUE for SKAT-type.}

\item{random_var}{Frailty variance in the case of random signs. Default: 0.}

\item{snps}{Number of SNP in the gene. Default: 100.}

\item{weights}{Aggregation weights.}
}
\value{
List containing: genotypes, annotations, covariates, phenotypes.
}
\description{
Generate a data set consisting of: \itemize{
\item{"anno"}{A SNP-length annotation vector.}
\item{"covar"}{A subject by 6 covariate matrix.}
\item{"geno"}{A subject by SNP genotype matrix.}
\item{"pheno"}{A subject-length phenotype vector.}
}
}
\examples{
# Generate data.
data <- DGP(n = 100)

# View components.
table(data$anno)
head(data$covar)
head(data$geno[, 1:5])
hist(data$pheno)
}
