% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plot_similarity_summary}
\alias{plot_similarity_summary}
\title{A line plot summary of column similarity between two multiple sequence alignments}
\usage{
plot_similarity_summary(x, scale = TRUE, cys = FALSE, display = TRUE)
}
\arguments{
\item{x}{an object of type "pairwise alignment comparison" (typically the summary file generated by compare_alignments)}

\item{scale}{scale data to proportion of characters that are not conserved gaps (default = TRUE)}

\item{cys}{additionally show the cysteine abundance for each column (default = FALSE)}

\item{display}{display this plot (default = TRUE)}
}
\description{
A line plot summary of column similarity between two multiple sequence alignments
}
\note{
This function generates a plot that summarises the similarity between the two multiple sequence alignments for each column of the reference alignment. For each column, it plots the proportion of identical character matches as a proportion of the characters that are not merely conserved gaps. The overall average proportion of identical characters that are not conserved gaps is overlaid as a percentage. For alignments of cysteine-rich proteins, the cysteine abundance for each column may also be plotted to indicate columns containing conserved cysteines (`cys=TRUE`).
}
\examples{
data(reference_alignment)
data(comparison_alignment)
PAC <- compare_alignments(reference_alignment,comparison_alignment)
plot_similarity_summary(PAC, cys=TRUE)

}

