% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pas_getIDs.R
\name{pas_getIDs}
\alias{pas_getIDs}
\title{Return IDs from filtered PurpleAir Synoptic objects}
\usage{
pas_getIDs(
  pas = NULL,
  pattern = ".*",
  idPattern = ".*",
  isOutside = TRUE,
  isParent = TRUE
)
}
\arguments{
\item{pas}{PurpleAir Synoptic \emph{pas} object.}

\item{pattern}{Text pattern used to filter station labels.}

\item{idPattern}{Text pattern used to filter \code{deviceDeploymentID}.}

\item{isOutside}{Logical, is the sensor located outside?}

\item{isParent}{Logical, is the record associated with a the A channel?}
}
\value{
Vector of values.
}
\description{
The incoming \code{pas} object is first filtered based on the 
values of \code{stateCodes}, \code{patter}, \code{isOutside} and \code{isParent}.
The values associated with the \code{"ID"} column are then returned.

This function is useful for returning values associated with specific
\emph{devices}, which are represented by records with \code{isParent = TRUE}.
}
\seealso{
\code{\link{pas_getColumn}},  \code{\link{pas_getLabels}}
}
