% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aqiColors.R
\name{aqiColors}
\alias{aqiColors}
\title{Generate AQI colors}
\usage{
aqiColors(
  x,
  pollutant = c("PM2.5", "AQI", "CO", "NO", "OZONE", "PM10", "SO2"),
  palette = c("EPA", "subdued", "deuteranopia"),
  na.color = NA
)
}
\arguments{
\item{x}{Vector or matrix of PM2.5 values or an \emph{mts_monitor} object.}

\item{pollutant}{EPA AQS criteria pollutant.}

\item{palette}{Named color palette to use for AQI categories.}

\item{na.color}{Color assigned to missing values.}
}
\value{
A vector or matrix of AQI colors to be used in maps and plots.
}
\description{
This function uses the \code{leaflet::colorBin()} function to return a
vector or matrix of colors derived from data values.
}
\examples{
library(AirMonitor)

# Fancy plot based on pm2.5 values
pm2.5 <- Carmel_Valley$data[,2]
Carmel_Valley \%>\%
  monitor_timeseriesPlot(
    shadedNight = TRUE,
    pch = 16,
    cex = pmax(pm2.5 / 100, 0.5),
    col = aqiColors(pm2.5),
    opacity = 0.8
  )
}
