% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airsis_loadAnnual.R
\name{airsis_loadAnnual}
\alias{airsis_loadAnnual}
\title{Load annual AIRSIS monitoring data}
\usage{
airsis_loadAnnual(
  year = NULL,
  archiveBaseUrl = paste0("https://airfire-data-exports.s3.us-west-2.amazonaws.com/",
    "monitoring/v2"),
  archiveBaseDir = NULL,
  QC_negativeValues = c("zero", "na", "ignore"),
  QC_removeSuspectData = TRUE
)
}
\arguments{
\item{year}{Year [YYYY].}

\item{archiveBaseUrl}{Base URL for monitoring v2 data files.}

\item{archiveBaseDir}{Local base directory for monitoring v2 data files.}

\item{QC_negativeValues}{Type of QC to apply to negative values.}

\item{QC_removeSuspectData}{Removes monitors determined to be misbehaving.}
}
\value{
A \emph{mts_monitor} object with AIRSIS data. (A list with
\code{meta} and \code{data} dataframes.)
}
\description{
Loads pre-generated .rda files containing annual
AIRSIS data.

If \code{archiveDataDir} is defined, data will be loaded from this local
archive. Otherwise, data will be loaded from the monitoring data repository
maintained by the USFS AirFire team.

Current year files loaded by this function are updated once per week.

For the most recent data in the last 10 days, use \code{airsis_loadLatest()}.

For daily updates covering the most recent 45 days, use \code{airsis_loadDaily()}.
}
\note{
Some older AIRSIS timeseries contain only values of 0, 1000, 2000, 3000, ... ug/m3.
Data from these deployments pass instrument-level QC checks but these
timeseries generally do not represent valid data and should be removed.
With \code{QC_removeSuspectData = TRUE} (the default), data is checked and
periods reporting only values of 0:10 * 1000 ug/m3 are invalidated.

Only those personally familiar with the individual instrument deployments
should work with the "suspect" data.
}
\examples{
\dontrun{
library(AirMonitor)

# Fail gracefully if any resources are not available
try({

# See https://en.wikipedia.org/wiki/Camp_Fire_(2018)

# AIRSIS monitors during the Camp Fire
airsis_loadAnnual(2018) \\%>\\%
  monitor_filter(stateCode == "CA") \\%>\\%
  monitor_filterDate(20181101, 20181201) \\%>\\%
  monitor_dropEmpty() \\%>\\%
  monitor_leaflet()

}, silent = FALSE)
}
}
\seealso{
\code{\link{airsis_loadDaily}}

\code{\link{airsis_loadLatest}}
}
