% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{NW_Megafires}
\alias{NW_Megafires}
\title{NW_Megafires example dataset}
\format{
A \emph{mts_monitor} object with 1080 rows and 143 columns of data.
}
\usage{
NW_Megafires
}
\description{
The \code{NW_Megafires} dataset provides a quickly loadable
version of a \emph{mts_monitor} object for practicing and code examples.
}
\details{
In the summer of 2015, Washington state had several catastrophic wildfires
that led to many days of heavy smoke in eastern Washington, Oregon and
northern Idaho. The NW_Megafires dataset contains monitoring data for the
Pacific Northwest from July 24 through September 06, 2015.

This dataset was generated on 2022-10-28 by running:

\preformatted{
library(AirMonitor)

NW_Megafires <-
  monitor_loadAnnual(2015, epaPreference = "epa_aqs") %>%
  monitor_filterMeta(stateCode %in% c("WA", "OR", "ID")) %>%
  monitor_filterDate(20150724, 20150907, timezone = "America/Los_Angeles") %>%
  monitor_dropEmpty()

save(NW_Megafires, file = "data/NW_Megafires.rda")
}
}
\keyword{datasets}
